﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak_1._5
{
    class Program
    {
        static void Main(string[] args)
        {
            Dokument doc = new Dokument();
            Paragraf paragraf = new Paragraf("Molimo pametne i poštene da čuvaju zdravlje i ne gube nadu. Za svaki slučaj. Ako nam niko drugi ne pomogne.");
            doc.addElement(paragraf);
            Recenica recenica1 = new Recenica("Deco, možete misliti kakav je život kada je od kolevke pa do groba najlepše đačko doba.");
            doc.addElement(recenica1);
            Recenica recenica2 = new Recenica("Više je znanja i veštine (inteligencije, duha, mašte i ukusa) uložila Koka-kola za propagandu svoje obojenei zašećerene vode, nego škola za slavu i veličanje čitanja i pisanja.");
            doc.addElement(recenica2);
            Pravougaonik pravougaonik = new Pravougaonik(1, 1, 2, 2, "crvena");
            doc.addElement(pravougaonik);
            doc.ToString();
            List<TekstualniElement> lista = doc.getTextElements();
            Console.WriteLine("String reprezentacija svih elemenata :");
            foreach(var x in lista)
            {
                string p = x.getText();
                Console.WriteLine(p);
            }
            int a = 0;
            foreach(var x in lista)
            {
                string p = x.getText();
                foreach (char k in p)
                {
                    if(k == 'a')
                    {
                        a++;
                    }
                }
            }
            Console.WriteLine("Broj pojavljivanja slova a : " + a);
            Console.ReadKey();
        }
    }

    class ElementUDokumentu
    {
        public string vrsta { set; get; }
        public ElementUDokumentu() { }
        public ElementUDokumentu(string vrsta) { }
        public override string ToString()
        {
            return vrsta;
        }
    }

    abstract class TekstualniElement
    {
        public abstract string getText();
        public TekstualniElement(string vrsta) { }
    }

    class Recenica : TekstualniElement
    {
        public string recenica { get; set; }
        public Recenica(string recenica):base("recenica")
        {
            if (recenica[recenica.Length - 1] == '.')
            {
                recenica.Remove(recenica.Length - 1, 1);
                this.recenica = recenica;
            }
            else
                this.recenica = recenica;
        }

        public override string getText()
        {
            return recenica + '.';
        }

        public override string ToString()
        {
            return "Vrsta : " + recenica;
        }
    }

    class Paragraf : TekstualniElement
    {
        StringBuilder sb = new StringBuilder();
        // \n
        public Paragraf(string recenica) : base("paragraf")
        {
            int x = 0;
            string s = recenica;
            x = recenica.IndexOf(" \n ");
            if (x > 0)
            {
                s = recenica.Substring(0, x);
            }
            this.sb.Append(s);
        }
        public Paragraf(Recenica a):base("paragraf")
        {
            this.sb.Append(a.recenica);
        }
        public void dodajTekst(string tekst)
        {
            tekst = ". " + tekst;
            sb.Append(tekst);
        }
        public void dodajTekst(Recenica a)
        {
            a.recenica = ". " + a.recenica;
            sb.Append(a.recenica);
        }
        public override string getText()
        {
            return sb.Append("\n").ToString();
        }

        public override string ToString()
        {
            return "Vrsta : " + sb;
        }
    }

    class GrafickiElement : ElementUDokumentu
    {
        public string boja { set; get; }
        public GrafickiElement(string vrsta, string boja) { }
    }

    class Pravougaonik : GrafickiElement
    {
        public int x1 { set; get; }
        public int y1 { set; get; }
        public int x2 { set; get; }
        public int y2 { set; get; }

        public Pravougaonik(int x1, int y1, int x2, int y2, string boja):base("pravougaonik", boja)
        {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.boja = boja;
        }

        public override string ToString()
        {
            return boja + "((" + x1 + ", " + y1 + "), " + (x2 - x1) + ", " + (y2 - y1) + ")";
        }
    }

    class Dokument
    {
        List<GrafickiElement> grafickiElementi = new List<GrafickiElement>();
        List<TekstualniElement> tekstualniElementi = new List<TekstualniElement>();
        public void addElement(TekstualniElement element)
        {
            tekstualniElementi.Add(element);
        }
        public void addElement(GrafickiElement element)
        {
            grafickiElementi.Add(element);
        }
        public void printText()
        {
            foreach(var x in tekstualniElementi)
            {
                Console.WriteLine(x);
            }
        }
        public List<TekstualniElement> getTextElements()
        {
            return tekstualniElementi;
        }

        public override string ToString()
        {
            foreach(var x in grafickiElementi)
            {
                Console.WriteLine(x.ToString());
            }
            foreach(var x in tekstualniElementi)
            {
                Console.WriteLine(x.ToString());
            }
            return "";
        }
    }
}
